/*	Renegade Scripts.dll
	Example Plugin Code
	Copyright 2007 Whitedragon(MDB), Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

/*  This is designed to serve as both an example on how to make a plugin and to give users the basic framework of a plugin.
    The plugin is simple: it creates an object creation hook and attaches the script "Plugin_Example_Script" to all objects.
	The script prints out a message whenever an object is created or destroyed.
	There are also examples of the new format for bhs.dll hooks.
*/

#include "scripts.h"
#include <stdarg.h>
#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include "engine.h"
#include "gmmain.h"
#include "plugin.h"

#define PURCHASE_HAPPENED 1232
#define VEHICLE_ACTION_HAPPENED 2222
#define GUY_SPOKE 3444

ExampleSettingsStruct *ExampleSettings = 0;

typedef cPlayer *(*Find_Player2) (int);
Find_Player2 FindPlayer2 = (Find_Player2)0x004157E0;

void ExampleSettingsStruct::Load() {
	SettingsLoader::Load();

	LoadInt(wait_time,"wait_time");
	LoadInt(score_threshold,"score_threshold");
	LoadBool(pm_afk_marked_player,"pm_afk_marked_player");
	LoadBool(no_pointscheck_dead_pp,"no_pointscheck_dead_pp");
	LoadBool(no_pointscheck_dead_ref,"no_pointscheck_dead_ref");
	LoadSString(pm_marked_player_string, "pm_marked_player_string");
}


int ObjectHookID = 0;
ObjectCreateHookStruct *ObjectHookStruct = 0;

int wait_time = 0;
int score_threshold = 0;

void ObjectHookCall(void *data,GameObject *obj) {
	if ( Commands->Is_A_Star(obj) )
	{
		Attach_Script_Once(obj,"Iran_AFK_Detector","");
	}
	else if ( Is_Vehicle(obj) )
	{
		Attach_Script_Once(obj,"Iran_AFK_Vehicle_Check","");
	}
}


void Plugin_Load() {
	ExampleSettings = new ExampleSettingsStruct("afk_detector.ini");
	ExampleSettings->Load();

	ObjectHookStruct = new ObjectCreateHookStruct;
	ObjectHookStruct->hook = ObjectHookCall;
	ObjectHookStruct->data = 0;
	ObjectHookID = AddObjectCreateHook(ObjectHookStruct);
	
	wait_time = ExampleSettings->wait_time;
	score_threshold = ExampleSettings->score_threshold;
	AddVehiclePurchaseMonHook(Purchase_Monitor_Hook, "0");
	AddCharacterPurchaseMonHook(Purchase_Monitor_Hook, "1");
	AddPowerupPurchaseMonHook(Purchase_Monitor_Hook, "2");
}


void Plugin_Unload() {
	delete ExampleSettings;
	delete ObjectHookStruct;
}


void Purchase_Monitor_Hook(BaseControllerClass *base, GameObject *purchaser, unsigned int cost, unsigned int preset,unsigned int purchaseret,const char *data)
{
	Commands->Send_Custom_Event(purchaser, purchaser, PURCHASE_HAPPENED, 0, 0.0f);
}

void Iran_AFK_Vehicle_Check::Custom(GameObject *obj, int message, int param, GameObject *sender)
{
	if ( (message == CUSTOM_EVENT_VEHICLE_ENTER) || (message == CUSTOM_EVENT_VEHICLE_EXIT) )
	{
		Commands->Send_Custom_Event(sender, sender, VEHICLE_ACTION_HAPPENED, 0, 0.0f);
	}
}

ScriptRegistrant<Iran_AFK_Vehicle_Check> Iran_AFK_Vehicle_Check_Registrant("Iran_AFK_Vehicle_Check","");

void Iran_AFK_Detector::Created(GameObject *obj) 
{
	scorecount = 0;
	poscount = 0;
	facingcount = 0;
	shotsfiredcount = 0;
	Commands->Start_Timer(obj,this,3.0f,1);
}

void Iran_AFK_Detector::Custom(GameObject *obj, int message, int param, GameObject *sender)
{
	if ( message == PURCHASE_HAPPENED )
	{
		didpurchase = true;
	}
	else if ( message == GUY_SPOKE )
	{
		hasspoken = true;
	}
	else if ( message == VEHICLE_ACTION_HAPPENED )
	{
		didvehicleaction = true;
	}
}

void Iran_AFK_Detector::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
	{
		oldpos = Commands->Get_Position(obj);
		oldscore = Get_Score(Get_Player_ID(obj));
		oldfacing = Commands->Get_Facing(obj);

		cPlayer *cplayer = FindPlayer2(Get_Player_ID(obj));
		oldshotsfired = cplayer->ShotsFired;

		hasspoken = false;
		didvehicleaction = false; 
		didpurchase = false;

		Commands->Start_Timer(obj,this,(float)wait_time,2);
	}
	if (number == 2)
	{
		if ( The_Game()->CurrentPlayers < 2 )
		{
			Commands->Start_Timer(obj,this,(float)wait_time,1);
			return;
		}

		float x, y, z;
		newpos = Commands->Get_Position(obj);
		newscore = Get_Score(Get_Player_ID(obj));
		newfacing = Commands->Get_Facing(obj);

		cPlayer *cplayer2 = FindPlayer2(Get_Player_ID(obj));
		newshotsfired = cplayer2->ShotsFired;

		x = fabs((oldpos.X - newpos.X));
		y = fabs((oldpos.Y - newpos.Y));
		z = fabs((oldpos.Z - newpos.Z));

		if ( x < 2.0f && y < 2.0f && z < 2.0f )
		{
			poscount++;
			posunchanged = true;
		}
		
		else
		{
			poscount = 0;
			posunchanged = false;
		}

		if ( (newscore - oldscore) <= score_threshold )
		{
			scorecount++;
			scoreunchanged = true;
		}

		else
		{
			scorecount = 0;
			scoreunchanged = false;
		}
		
		int type = Commands->Get_Player_Type(obj);
		if ( (ExampleSettings->no_pointscheck_dead_ref && Is_Building_Dead(Find_Refinery(type))) ||
			( ExampleSettings->no_pointscheck_dead_pp && Is_Building_Dead(Find_Power_Plant(type))) )
		{
			scorecount = 0;
			scoreunchanged = false;
		}

		if ( oldfacing == newfacing )
		{
			facingcount++;
			facingunchanged = true;
		}
		else
		{
			facingcount = 0;
			facingunchanged = false;
		}

		if ( newshotsfired <= oldshotsfired)
		{
			shotsfiredcount++;
			shotsfiredunchanged = true;
		}
		else
		{
			shotsfiredcount = 0;
			shotsfiredunchanged = false;
		}

		if ( hasspoken || didvehicleaction || didpurchase)
		{
			hasspoken = false;
			didvehicleaction = false; 
			didpurchase = false;
			Commands->Start_Timer(obj,this,(float)wait_time,2);
			return;
		}
		hasspoken = false;
		didvehicleaction = false;
		didpurchase = false;

		if ( !posunchanged && !scoreunchanged && !facingunchanged)
		{
			oldpos = newpos;
			oldscore = newscore;
			oldfacing = newfacing;
			oldshotsfired = newshotsfired;
			Commands->Start_Timer(obj,this,(float)wait_time,2);
			return;
		}
		char tmp[256];
		sprintf(tmp, "[AFK] %s's", Get_Player_Name(obj));

		if ( posunchanged )
		{
			std::string closest = Get_Closest_Building_Name(obj);
			sprintf(tmp, "%s position(count: %d%s)", tmp, poscount, closest.c_str());			
		}		
		if ( scoreunchanged )
		{
			sprintf(tmp, "%s score(%.0f, count: %d)", tmp, newscore, scorecount);
		}		
		if ( facingunchanged )
		{
			sprintf(tmp, "%s facing(count: %d)", tmp, facingcount);
		}
		if ( shotsfiredunchanged )
		{
			sprintf(tmp,"%s shots fired with infantry(count: %d)", tmp, shotsfiredcount);
		}

		sprintf(tmp, "%s hasn't changed.", tmp);
		WriteLog(tmp, 1);

		if ( ExampleSettings->pm_afk_marked_player )
		{
			char tmp[128];
			sprintf(tmp, "ppage %d %s", Get_Player_ID(obj), ExampleSettings->pm_marked_player_string.c_str());
			Console_Input(tmp);
		}

		oldpos = newpos;
		oldscore = newscore;
		oldfacing = newfacing;
		oldshotsfired = newshotsfired;
		Commands->Start_Timer(obj,this,(float)wait_time,2);
	}
}

ScriptRegistrant<Iran_AFK_Detector> Iran_AFK_Detector_Registrant("Iran_AFK_Detector","");

std::string Get_Closest_Building_Name(GameObject* obj)
{
	int nearref = 0;
	int nearpp = 0;
	int neardefense = 0;
	int nearweps = 0;
	int nearbar = 0;
	int notnearbuildings = 0;

	int team = Get_Team(Get_Player_ID(obj));

	if ( team != 0 && team != 1) {
		return std::string("");
	}
	else
	{
		GameObject *ref = Find_Refinery(team);
		Vector3 refpos = Commands->Get_Position(ref);
		GameObject *pp = Find_Power_Plant(team);
		Vector3 pppos = Commands->Get_Position(pp);
		GameObject *bar = Find_Soldier_Factory(team);
		Vector3 barpos = Commands->Get_Position(bar);
		GameObject *defense = Find_Base_Defense(team);
		Vector3 defensepos = Commands->Get_Position(defense);
		GameObject *weps = Find_Vehicle_Factory(team);
		Vector3 wepspos = Commands->Get_Position(weps);

		Vector3 currpos = Commands->Get_Position(obj);

		if (Commands->Get_Distance(currpos,refpos) < Commands->Get_Distance(currpos,pppos) && Commands->Get_Distance(currpos,refpos) < Commands->Get_Distance(currpos,barpos) && Commands->Get_Distance(currpos,refpos) < Commands->Get_Distance(currpos,defensepos) && Commands->Get_Distance(currpos,refpos) < Commands->Get_Distance(currpos,wepspos))
		{
			if (Commands->Get_Distance(currpos,refpos) < 35.0f)
			{
				nearref = 1;
			}
			else
			{
				notnearbuildings = 1; 
			}
		}
		else if (Commands->Get_Distance(currpos,pppos) < Commands->Get_Distance(currpos,refpos) && Commands->Get_Distance(currpos,pppos) < Commands->Get_Distance(currpos,barpos) && Commands->Get_Distance(currpos,pppos) < Commands->Get_Distance(currpos,defensepos) && Commands->Get_Distance(currpos,pppos) < Commands->Get_Distance(currpos,wepspos))
		{
			if (Commands->Get_Distance(currpos,pppos) < 35.0f)
			{
				nearpp = 1;
			}
			else
			{
				notnearbuildings = 1; 
			}
		}
		else if (Commands->Get_Distance(currpos,defensepos) < Commands->Get_Distance(currpos,refpos) && Commands->Get_Distance(currpos,defensepos) < Commands->Get_Distance(currpos,barpos) && Commands->Get_Distance(currpos,defensepos) < Commands->Get_Distance(currpos,refpos) && Commands->Get_Distance(currpos,defensepos) < Commands->Get_Distance(currpos,wepspos))
		{
			if (Commands->Get_Distance(currpos,defensepos) < 15.0f)
			{
				neardefense = 1;
			}
			else
			{
				notnearbuildings = 1; 
			}
		}
		else if (Commands->Get_Distance(currpos,wepspos) < Commands->Get_Distance(currpos,refpos) && Commands->Get_Distance(currpos,wepspos) < Commands->Get_Distance(currpos,barpos) && Commands->Get_Distance(currpos,wepspos) < Commands->Get_Distance(currpos,refpos) && Commands->Get_Distance(currpos,wepspos) < Commands->Get_Distance(currpos,defensepos))
		{
			if (Commands->Get_Distance(currpos,wepspos) < 35.0f)
			{
				nearweps = 1;
			}
				else
			{
				notnearbuildings += 1; 
			}
		}
		else if (Commands->Get_Distance(currpos,barpos) < Commands->Get_Distance(currpos,refpos) && Commands->Get_Distance(currpos,barpos) < Commands->Get_Distance(currpos,wepspos) && Commands->Get_Distance(currpos,barpos) < Commands->Get_Distance(currpos,refpos) && Commands->Get_Distance(currpos,barpos) < Commands->Get_Distance(currpos,defensepos))
		{
			if (Commands->Get_Distance(currpos,barpos) < 34.0f)
			{
				nearbar = 1;
			}
			else
			{
				notnearbuildings = 1; 
			}

		}
		
		std::string tmp;
		if (nearref)
		{
			tmp = ", near Refinery";
			return tmp;
		}
		else if (nearpp)
		{
			tmp = ", near Power Plant";
			return tmp;
		}
		else if (neardefense)
		{
			tmp = team ? ", near AGT" : ", near Obelisk";
			return tmp;
		}
		else if (nearweps)
		{
			tmp = team ? ", near WF" : ", near Airstrip";
			return tmp;
		}
		else if (nearbar)
		{
			tmp = team ? ", near Bar" : ", near HoN";
			return tmp;
		}
		else if (notnearbuildings)
		{
			return std::string("");
		}
	}
	return std::string("");
};

extern "C" {

DLLEXPORT void SSGM_Chat_Hook(int ID, int Type, const wchar_t *Msg) 
{	
	GameObject* obj = Get_GameObj(ID);
	Commands->Send_Custom_Event(obj, obj, GUY_SPOKE, 0, 0.0F);
}
}